 static var isPaused : boolean = false;
 var startTime : float; //(in seconds)
 var timeLeft : float; //(in seconds)
 var percent:float;

 var clockBG:Texture2D;
 var clockFG:Texture2D;
 var clockFGMaxWidth:float; // the starting width of the foreground bar

 var rightSide:Texture2D;
 var leftSide:Texture2D;
 var back:Texture2D;
 var blocker:Texture2D;
 var shiny:Texture2D;
 var finished:Texture2D;
 var timeRemainingText:Texture2D;

function Start()
{
startTime = 90.0;
timeLeft=startTime;
guiText.material.color = Color.black;
clockFGMaxWidth = clockFG.width;
}
function Update() {

if (!isPaused)
{
// make sure the timer is not paused
DoCountdown();
}

}
function DoCountdown() {
timeLeft -= Time.deltaTime;
if ( timeLeft < 0 ) {
       timeLeft = 0;
        Time.timeScale = 0;
        isPaused = true;
        
    } else {
        Time.timeScale = 1;
    }
percent = timeLeft/startTime * 100;
ShowTime();
Debug.Log("Time Left= "+timeLeft+"  Time.deltaTime= "+Time.deltaTime+"  Percent= "+percent);
//Debug.Log("time remaining = " + timeRemaining + " ::time counting = " + Time.time + " ::time start= " + startTime);//changes here
}

function PauseClock()
{
isPaused = true;
}

function UnpauseClock()
{
isPaused = false;
}

function ShowTime()
{
var minutes : int;
var seconds : int;
var timeStr : String;
minutes = timeLeft/60;
seconds = timeLeft % 60;
timeStr = minutes.ToString() + ":";
timeStr += seconds.ToString("D2");
guiText.text = timeStr; //display the time to the GUI
}

function TimeIsUp()
{

var losePromptW:int = 200;
var losePromptH:int = 90;
var halfScreenW:float = Screen.width/2;
var halfScreenH:float = Screen.height/2;
var halfPromptW:int = losePromptW/2;
var halfPromptH:int = losePromptH/2;
GUI.BeginGroup(Rect(halfScreenW-halfPromptW,halfScreenH-halfPromptH, losePromptW, losePromptH));
GUI.Box (Rect (0,0,losePromptW,losePromptH),"Time Up! Please Try Again...");
if(GUI.Button(Rect(60,40,80,30),"Play Again"))
{
Application.LoadLevel("Title");
}
GUI.EndGroup();
}

function OnGUI()
{
var isPastHalfway:boolean = percent < 50;
var pieClockX:int = Screen.width/20;
var pieClockY:int = Screen.height/10;
var pieClockW:int = 100; // clock width
var pieClockH:int = 100; // clock height
var offset:int=100; //offset for time remaining text
var pieClockHalfW:int = pieClockW * 0.5; // half the clock width
var pieClockHalfH:int = pieClockH * 0.5; // half the clock height

var clockRect:Rect = Rect(pieClockX, pieClockY, pieClockW,pieClockH);
var timeRemainingTextRect:Rect = Rect(pieClockX, pieClockY+offset, pieClockW,pieClockH/2);
var rot:float = (percent/100) * 360;
var centerPoint:Vector2 = Vector2(pieClockX + pieClockHalfW,pieClockY + pieClockHalfH);
var startMatrix:Matrix4x4 = GUI.matrix;

GUI.DrawTexture(timeRemainingTextRect,timeRemainingText,ScaleMode.StretchToFill, true,0);
GUI.DrawTexture(clockRect, back, ScaleMode.StretchToFill, true,0);

if(isPastHalfway)
{

GUIUtility.RotateAroundPivot(-rot-180, centerPoint);
GUI.DrawTexture(clockRect, leftSide, ScaleMode.StretchToFill,true, 0);
GUI.matrix = startMatrix;
GUI.DrawTexture(clockRect, blocker, ScaleMode.StretchToFill,true, 0);	

}
else
{
GUI.DrawTexture(clockRect, leftSide, ScaleMode.StretchToFill,true, 0);
GUIUtility.RotateAroundPivot(-rot, centerPoint);
GUI.DrawTexture(clockRect, rightSide, ScaleMode.StretchToFill,true, 0);
GUI.matrix = startMatrix;
}

if(percent == 0)
{
GUI.DrawTexture(clockRect, finished, ScaleMode.StretchToFill,true, 0);
isPastHalfway=false;
TimeIsUp();
GameScript.playerCanClick=false;
}
GUI.DrawTexture(clockRect, shiny, ScaleMode.StretchToFill, true,0);

}
